/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.MailAddress;

/**
 *
 * @author root
 */
public class AddressCheck implements Serializable{
    private static final Log LOGGER = LogFactory.getFactory().getInstance(
            AddressCheck.class);
    private HashMap<MailAddress,Integer> mailbox;
    private HashMap<MailAddress,Integer> group;
    private ArrayList<MailAddress> badaddress;
    private boolean failed = true;
    public AddressCheck(ArrayList<MailAddress> addresses, String[] Domains){
        HashMap<String,Integer> usernametoids = new HashMap<String,Integer>();
        HashMap<String,Integer> usernametogroup = new HashMap<String,Integer>();
        badaddress = new ArrayList<MailAddress>();
        mailbox = new HashMap<MailAddress,Integer>();
        group = new HashMap<MailAddress,Integer>();
        Connection conn = null;
        try {
            // query to see if the user record exists for local system
            Map<String, String> propertiesMap = MailetProperties.getPropertiesList();
            String db_hostname = propertiesMap.get("mailet.db.hostname");
            String db_port = propertiesMap.get("mailet.db.port");
            String db_name = propertiesMap.get("mailet.db.mailname");
            String db_instance = propertiesMap.get("mailet.db.instance");
            String db_userid = propertiesMap.get("mailet.db.mailusername");
            String db_password = propertiesMap
                    .get("mailet.db.mailpassword");

            try {
                conn = databaseConnect(db_hostname, db_port, db_name,
                        db_instance, db_userid, db_password);
            } catch (SQLException e) {
                LOGGER.trace("Failed to connect to SQL Server");
            }
            PreparedStatement prepQuery = null;
            if(conn != null){
                try{
                    String sqlQuery = "SELECT id, name, is_group FROM mailboxes WHERE name in (" + (StringUtils.repeat("?,", addresses.size()));
                    sqlQuery =sqlQuery.substring(0, sqlQuery.length() - 1) + ')';
                    prepQuery = conn.prepareStatement(sqlQuery);
                    for (int c = 0; c < addresses.size(); c++) {
                        prepQuery.setString(c + 1, addresses.get(c).getLocalPart());
                        
                    }
                    // try to execute query
                    ResultSet rs = null;
                    try{
                        rs = prepQuery.executeQuery();
                        while (rs.next()) {
                            usernametoids.put(rs.getString("name").toLowerCase(), rs.getInt("id"));
                            usernametogroup.put(rs.getString("name").toLowerCase(), rs.getInt("is_group"));
                        }
                        List<String> domainSet = Arrays.asList(Domains);
                        for(MailAddress address : addresses){
                            if(domainSet.contains(address.getDomain().toLowerCase()) && usernametoids.containsKey(address.getLocalPart().toLowerCase())){
                                mailbox.put(address, usernametoids.get(address.getLocalPart().toLowerCase()));
                                group.put(address, usernametogroup.get(address.getLocalPart().toLowerCase()));
                            }
                            else{
                                badaddress.add(address);
                            }
                        }
                        rs.close();
                        failed = false;
                    }finally{
                        if(rs!= null){
                            rs.close();
                        }
                    }
                }finally{
                    if(prepQuery != null){
                        prepQuery.close();
                    }
                }
                
            }

        } catch (SQLException e) {
            LOGGER.debug("SQL Exception for bad query statement in users exists function.");
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    LOGGER.debug("Failed to close connection");
                }

            }
        }
    
    }
    
    public HashMap<MailAddress,Integer> getMailbox(){
        return mailbox;
    }
    public boolean isGroup(MailAddress address){
        if(group.get(address) == 1){
            return true;
        }
        return false;
    }
    
    public ArrayList<MailAddress> getBadAddress(){
        return badaddress;
    }
    private static Connection databaseConnect(String db_hostname,
            String db_port, String db_name, String db_instance,
            String db_userid, String db_prd) throws SQLException {
        Connection conn = null;
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":"
                + db_port + ";databaseName=" + db_name
                + ";ssl=require;hostNameInCertificate=" + db_hostname
                + ";instanceName=" + db_instance + ";portNumber=" + db_port
                + ";trustServerCertificate=true";

        // Load DB Driver
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        } catch (ClassNotFoundException f) {
            LOGGER.trace("Could not load SQL Server DB driver");
        }

        // Connect to DB
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid,
                    db_prd);
        } catch (SQLException sqlException) {
            LOGGER.trace("SQL Server database not reachable");
            return null;
        }

        return conn;
    }
    public void removeAddress(MailAddress address){
    	mailbox.remove(address);
    	group.remove(address);
    }
    public boolean getFailed(){
    	return failed;
    }
    
    
}
